import re

def get_tree(f):
    line = f.readline()
    m = re.search(r'leaf=(.+)$', line)
    if m: return "r+={0};".format(m.group(1))
    m = re.search(r'f([0-9]+)\<(.+?)\]', line)
    if m: return "if(f[{0}]<{1}){{{2}}}else{{{3}}}".format(m.group(1), m.group(2), get_tree(f), get_tree(f))

def parse_xgboost(filename, count_limit):
    f = open(filename, 'r')
    ret = []
    for i in range(0, count_limit):
        if f.readline(): ret.append(get_tree(f))
    f.close()
    return ret

ret = []
for i in range(0,8):
    ret += parse_xgboost("model{0}.txt".format(i), 4)
f = open('model_c.txt', 'w')
f.write("public static double predict(double[] f){{return {0};}}\n".format("+".join(["p{0}(f)".format(i) for i in range(0, len(ret))])))
for i in range(0,len(ret)):
    f.write("static double p{0}(double[] f){{double r=0;{1} return r;}}\n".format(i, ret[i]))
f.close()